function JCheckbox(owner, parent, name, dataset, field, rect, tab)
{
	var self = this,
		_disposed = false;

	this.initialize(owner, parent, name, null, null, rect, null, field, dataset, tab);

	this.methods   = (cmRender | cmLoad);

	this.render = render;
	this.load   = load;
	this.dispose = dispose;
	this.click  = click;

	function render(fs)
	{
		if (self.isInvisible())
			return;

		var readOnly = self.dataset.isReadOnly(self.field);

		var addClass = '';
/*
		if (self.isInvisible())
		{
			addClass += ' invisible';
		}
*/

		var val = self.dataset.get(self.field, 0);

		var add = ((val == "true") || (val == 1)) ? ' checked="checked"' : '';
		add += (readOnly) ? ' disabled="true"' : '';

		fs.append('<input id="' + self.name + '" name="' + self.name + '" type="checkbox" class="label'+ addClass + '" style="' + self.rect + '" ' + add + '>');

		return;
	}

	function load()
	{
		if (self.isInvisible())
			return;

		self.$$().onclick = self.click;
	}

	function click()
	{
		var rec = self.dataset.getRecNo();
		self.dataset.gotoRow(0);

		var record = self.dataset.getCurrentRecord();
		if ((record) && ((record.isNoData(self.field)) || (record.isReadOnly(self.field))))
			return;

		if (self.$$().checked)
			self.dataset.set(self.field, "true");
		else
			self.dataset.set(self.field, "false");

		self.dataset.gotoRow(rec);
	}

	function dispose()
	{
		if (_disposed)
			return;

		self.$$().onclick = null;

		self.base.dispose.call(self);
		_disposed = true;
	}

}

JCheckbox.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();